% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.MASkew}
\alias{test.MASkew}
\title{Test of normality based on multivariate skewness in the sense of Malkovich and Afifi}
\usage{
test.MASkew(data, MC.rep = 10000, alpha = 0.05, num.points = 1000)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}

\item{num.points}{number of points distributed uniformly over the sphere for approximation of the maximum on the sphere.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{number of points used in approximation.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
}
}
\description{
Computes the test of multivariate normality based on skewness in the sense of Malkovich and Afifi (1973).
}
\details{
Multivariate sample skewness due to Malkovich and Afifi (1973) is defined by
\deqn{b_{n,d,M}^{(1)}=\max_{u\in \{x\in\mathbf{R}^d:\|x\|=1\}}\frac{\left(\frac{1}{n}\sum_{j=1}^n(u^\top X_j-u^\top \overline{X}_n )^3\right)^2}{(u^\top S_n u)^3},}
where \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.
}
\examples{
\donttest{test.MASkew(MASS::mvrnorm(10,c(0,1),diag(1,2)),MC.rep=100)}

}
\references{
Malkovich, J.F., and Afifi, A.A. (1973), On tests for multivariate normality, J. Amer. Statist. Ass., 68:176-179.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467-506.
}
\seealso{
\code{\link{MASkew}}
}
