% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_C.R
\name{calc_S_C}
\alias{calc_S_C}
\title{Calculate species richness for a given coverage level.}
\usage{
calc_S_C(x, C_target = NULL, extrapolate = TRUE, interrupt = TRUE)
}
\arguments{
\item{x}{a site by species matrix or a species abundance distribution}

\item{C_target}{target coverage between 0 and 1 (default is NULL). If not
provided then target coverage is computed by \code{\link{calc_C_target}}}

\item{extrapolate}{logical. Defaults to TRUE in which case richness is 
extrapolated to sample sizes larger than observed in the dataset.}

\item{interrupt}{logical. Should the function throw an error when \code{C_target}
exceeds the maximum recommendable coverage?}
}
\value{
numeric value which is the species richness at a specific level of 
coverage.
}
\description{
This function uses coverage-based rarefaction to compute species richness.
Specifically, the metric is computed as the
}
\examples{
data(tank_comm)
# What is species richness for a coverage value of 60\%?
calc_S_C(tank_comm, C_target = 0.6)
}
\references{
Chao, A., and L. Jost. 2012. Coverage-based rarefaction and extrapolation:
 standardizing samples by completeness rather than size. Ecology 93:2533–2547.
 
Anne Chao, Nicholas J. Gotelli, T. C. Hsieh, Elizabeth L. Sander, K. H. Ma,
 Robert K. Colwell, and Aaron M. Ellison 2014. Rarefaction and extrapolation
 with Hill numbers: a framework for sampling and estimation in species
 diversity studies.  Ecological Monographs 84:45-67.

T. C. Hsieh, K. H. Ma and Anne Chao. 2024. 
 iNEXT: iNterpolation and EXTrapolation for
 species diversity. R package version 3.0.1
 URL: http://chao.stat.nthu.edu.tw/wordpress/software-download/.
}
\seealso{
\code{\link{invChat}}
}
