% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-NCN_curve_functions.R
\name{kNCN_average}
\alias{kNCN_average}
\title{Construct spatially constrained sample-based rarefaction (sSBR) curve using
the k-Nearest-Centroid-neighbor (k-NCN) algorithm}
\usage{
kNCN_average(
  x,
  n = NULL,
  coords = NULL,
  repetitions = 1,
  no_pb = TRUE,
  latlong = FALSE,
  cl = NULL
)
}
\arguments{
\item{x}{a mob_in object or a community site x species matrix}

\item{n}{number of sites to include.}

\item{coords}{spatial coordinates of the samples. If x is a mob_in object,
the function uses its 'spat' table as coordinates.}

\item{repetitions}{Number of times to repeat the procedure. Useful in
situations where there are many ties in the distance matrix.}

\item{no_pb}{binary, if TRUE then a progress bar is not printed, defaults to
TRUE}

\item{latlong}{if longitude latitudes are supplied}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}
}
\value{
a numeric vector of estimated species richness
}
\description{
This function accumulates samples according their proximity to all previously
included samples (their centroid) as opposed to the proximity to the initial
focal sample. This ensures that included samples mutually close to each other
and not all over the place.
}
\details{
Internally the function constructs one curve per sample whereby each sample
serves as the initial sample repetition times. Finally, the average curve is
returned.
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
kNCN_average(inv_mob_in, n = 5)
\donttest{
# parallel evaluation using the parallel package 
# run in parallel
library(parallel)
cl = makeCluster(2L)
clusterEvalQ(cl, library(mobr))
clusterExport(cl, 'inv_mob_in')
S_kNCN = kNCN_average(inv_mob_in, cl=cl)

stopCluster(cl)
}
}
