% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{plot_rarefaction}
\alias{plot_rarefaction}
\title{Plot rarefaction curves for each treatment group}
\usage{
plot_rarefaction(
  mob_in,
  group_var,
  ref_level = NULL,
  method,
  spat_algo = NULL,
  dens_ratio = 1,
  scales = c("alpha", "gamma", "study"),
  raw = TRUE,
  smooth = FALSE,
  avg = FALSE,
  col = NULL,
  lwd = 3,
  log = "",
  leg_loc = "topleft",
  one_panel = FALSE,
  ...
)
}
\arguments{
\item{mob_in}{a 'mob_in' class object produced by 'make_mob_in'}

\item{group_var}{String that specifies which field in \code{mob_in$env} the
data should be grouped by}

\item{ref_level}{String that defines the reference level of \code{group_var}
to which all other groups are compared with, defaults to \code{NULL}.
If \code{NULL} then the default contrasts of \code{group_var} are used.}

\item{method}{a character string that specifies the method of rarefaction 
  curve construction it can be one of the following: 
\itemize{
    \item \code{'IBR'} ... individual-based rarefaction in which species
    are accumulated by randomly sampling individuals
    \item \code{'SBR'} ... sample-based rarefaction in which species are 
    accumulated by randomly sampling samples (i.e., plots). Note that within plot spatial 
    aggregation is maintained with this approach. Although this curve
    is implemented here, it is not used in the current version of the MoB framework
    \item \code{'nsSBR'} ... non-spatial, sampled-based rarefaction in which
    species are accumulated by randomly sampling samples that represent a 
    spatially random sample of individuals (i.e., no with-in plot spatial 
    aggregation). The argument \code{dens_ratio} must also be set otherwise 
    this sampling results in a curve identical to the IBR (see Details). 
    \item \code{'sSBR'} ... spatial sample-based rarefaction in which species 
    are accumulated by including spatially proximate samples first.
    \item \code{'spexSBR'}  ... spatially-explicit sample-based rarefaction
    in which species are accumulated as in \code{'sSBR'} but sampling
    effort is not measured by no. of samples, but by cumulative distance or
    cumulative area as specified by \code{'spat_algo'} (see details)
}}

\item{spat_algo}{character string that can be either: \code{'kNN'},
\code{'kNCN'}, or \code{'convexhull'} for k-nearest neighbor, 
k-nearest centroid neighbor sampling, or convex-hull polygon calculation 
respectively. It defaults to k-nearest neighbor which is a 
more computationally efficient algorithm that closely approximates the 
potentially more correct k-NCN algo (see Details). Currently, \code{'kNN'} and
\code{'k-NCN'} are available for method \code{'ssBR'}, while \code{'kNN'}
\code{'convexhull'} are available for method \code{'spexSBR'}.}

\item{dens_ratio}{the ratio of individual density between a reference group
and the community data (i.e., x) under consideration. This argument is
used to rescale the rarefaction curve when estimating the effect of
individual density on group differences in richness.}

\item{scales}{character string which defaults to c('alpha', 'gamma', 'study')
indicating that rarefaction curves at the alpha (i.e., single plot), gamma 
(i.e., group of plots), and study (i.e., all plots) scales should be computed
and plotted.}

\item{raw}{boolean. Defaults to TRUE so that raw rarefaction curves
without averaging or smoothing are plotted}

\item{smooth}{boolean. Defaults to FALSE. If set to TRUE a lowess smoother is 
used on the 'alpha' scale curves. Has no effect at gamma or study scales}

\item{avg}{boolean. Defaults to FALSE. If set to TRUE then the average richness
across the groups is computed and plotted.}

\item{col}{optional vector of colors.}

\item{lwd}{a number which specifies the width of the lines}

\item{log}{a string that specifies if any axes are to be log transformed, 
options include 'x', 'y' or 'xy' in which either the x-axis, y-axis, or
both axes are log transformed respectively}

\item{leg_loc}{a string that specifies the location of the legend, 
options include: 'lowerleft', 'topleft', 'loweright','topright'}

\item{one_panel}{boolean. Defaults to FALSE. If set to TRUE then the alpha
scale and gamma scale curves are put on the same graph.}

\item{...}{other arguments to provide to \code{\link[mobr]{rarefaction}}}
}
\description{
Plot rarefaction curves for each treatment group
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
# random individual based rarefaction curves
par(mfrow=c(1,2))
plot_rarefaction(inv_mob_in, 'group', 'uninvaded', 'IBR',
                 leg_loc='bottomright')
plot_rarefaction(inv_mob_in, 'group', 'uninvaded', 'IBR',
                 log='xy')
# random sample based rarefaction curves 
plot_rarefaction(inv_mob_in, 'group', 'uninvaded', 'SBR', log='xy',
                 leg_loc='bottomright')
# spatial sample based rarefaction curves 
plot_rarefaction(inv_mob_in, 'group', 'uninvaded', 'sSBR', log='xy',
                 leg_loc='bottomright', avg = TRUE, smooth = TRUE)
}
