#' @title getxl Examples
#' @name xlex
#' @description use shiny module getxl/UI for interactive input of Excel files
#' @examples
#' library(shiny)
#' library(modgetxl)
#' app<- shinyApp(  
#'  ui= uiOutput('xltest'),
#'  
#'  server= function(input, output) {
#'  	sink(file=stderr())
#'  	options(shiny.maxRequestSize=1*1024^2) # 1MB
#'  
#'  	output$xltest<- renderUI({
#'  		getxlUI('server')
#'  		})
#'  
#'  	xl<- callModule(getxl, 'server')
#'  	# excel sheets info and data are available once user uploads excel file in UI
#'  	# returned xl has reactiveValues of two variables as below
#'  	observeEvent(xl$sheets,{
#'  		print(xl$sheets)
#'  		print(head(xl$sheetdata[[1]]))
#'  		})
#'  	}
#'  
#' )
#' \dontrun{
#'	runApp(app)
#' }
#'
NULL
