% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_modisfast.R
\name{mf_modisfast}
\alias{mf_modisfast}
\title{Download (and possibly import) MODIS, VIIRS and GPM
Earth Observation data}
\usage{
mf_modisfast(
  collection,
  variables,
  roi,
  time_range,
  path = tempfile("modisfast_"),
  earthdata_username,
  earthdata_password,
  parallel = FALSE,
  verbose = "inform",
  import = TRUE,
  ...
)
}
\arguments{
\item{collection}{string. mandatory. Collection of interest (see details of \link{mf_get_url}).}

\item{variables}{string vector. optional. Variables to retrieve for the collection of interest. If not specified (default) all available variables will be extracted (see details of \link{mf_get_url}).}

\item{roi}{object of class \code{sf}. mandatory. Area of region of interest. Must be a Simple feature collection with geometry type POLYGON, composed of one or several rows (i.e. one or several ROIs), and with at least two columns: 'id' (an identifier for the roi) and 'geom' (the geometry).}

\item{time_range}{date(s) / POSIXlt of interest . mandatory. Single date/datetime or time frame : vector with start and end dates/times (see details).}

\item{path}{string. Target folder for the data to download. Default : temporary folder.}

\item{earthdata_username}{EarthData username}

\item{earthdata_password}{EarthData username}

\item{parallel}{boolean. Parallelize the download ? Default to FALSE}

\item{verbose}{string. Verbose mode ("quiet", "inform", or "debug"). Default "inform".}

\item{import}{boolean. Import the data as a SpatRast object ? default TRUE. FALSE will download the data but not import them it in R.}

\item{...}{Further arguments to be passed to \link{mf_import_data}}
}
\value{
if the parameter \code{import} is set to TRUE, a \code{terra::SpatRast}
object ; else a data.frame providing details of the data downloaded
(see output of \link{mf_download_data}).
}
\description{
Download and possibly import MODIS, VIIRS and GPM
Earth Observation data quickly and efficiently.
This function is a wrapper for
\link{mf_login}, \link{mf_get_url}, \link{mf_download_data} and \link{mf_import_data}.
Whenever possible, users should prefer executing the functions \link{mf_login},
\link{mf_get_url}, \link{mf_download_data} and \link{mf_import_data} sequentially
rather than using this high-level function
}
\examples{
\dontrun{

### Set-up parameters of interest
coll <- "MOD11A1.061"

bands <- c("LST_Day_1km", "LST_Night_1km")

time_range <- as.Date(c("2017-01-01", "2017-01-30"))

roi <- sf::st_as_sf(
  data.frame(
    id = "roi_test",
    geom = "POLYGON ((-5.82 9.54, -5.42 9.55, -5.41 8.84, -5.81 8.84, -5.82 9.54))"
  ),
  wkt = "geom", crs = 4326
)

### Download and import the data
modis_ts <- mf_modisfast(
  collection = coll,
  variables = bands,
  roi = roi,
  time_range = time_range,
  earthdata_username = "earthdata_un",
  earthdata_password = "earthdata_pw"
 )

### Plot the data
terra::plot(modis_ts)
}
}
\seealso{
\link{mf_login}, \link{mf_get_url}, \link{mf_download_data}, \link{mf_import_data}
}
