% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatHierHMM.R
\name{formatHierHMM}
\alias{formatHierHMM}
\title{Convert hierarchical HMM structure to a conventional HMM}
\usage{
formatHierHMM(
  data,
  hierStates,
  hierDist,
  hierBeta = NULL,
  hierDelta = NULL,
  hierFormula = NULL,
  hierFormulaDelta = NULL,
  mixtures = 1,
  workBounds = NULL,
  betaCons = NULL,
  deltaCons = NULL,
  fixPar = NULL,
  checkData = TRUE
)
}
\arguments{
\item{data}{\code{\link{momentuHierHMMData}} object or a data frame containing the data streams and covariates.}

\item{hierStates}{A hierarchical data structure \code{\link[data.tree]{Node}} for the states ('state').  See \code{\link{fitHMM}}.}

\item{hierDist}{A hierarchical data structure \code{\link[data.tree]{Node}} for the data streams ('dist'). See \code{\link{fitHMM}}.}

\item{hierBeta}{A hierarchical data structure \code{\link[data.tree]{Node}} for the matrix of initial values for the regression coefficients of the transition probabilities at each level of the hierarchy ('beta'). See \code{\link{fitHMM}}.}

\item{hierDelta}{A hierarchical data structure \code{\link[data.tree]{Node}} for the matrix of initial values for the regression coefficients of the initial distribution at each level of the hierarchy ('delta'). See \code{\link{fitHMM}}.}

\item{hierFormula}{A hierarchical formula structure for the transition probability covariates for each level of the hierarchy ('formula'). See \code{\link{fitHMM}}. Default: \code{NULL} (only hierarchical-level effects, with no covariate effects).}

\item{hierFormulaDelta}{A hierarchical formula structure for the initial distribution covariates for each level of the hierarchy ('formulaDelta'). See \code{\link{fitHMM}}. Default: \code{NULL} (no covariate effects and \code{fixPar$delta} is specified on the working scale).}

\item{mixtures}{Number of mixtures for the state transition probabilities  (i.e. discrete random effects *sensu* DeRuiter et al. 2017). See \code{\link{fitHMM}}. Default: \code{mixtures=1}.}

\item{workBounds}{A list with elements named \code{'beta'} and/or \code{'delta'}, where each element is a hierarchical data structure \code{\link[data.tree]{Node}} indicating t.p.m. and initial distribution working parameter bounds ('workBounds') for parameters in \code{hierBeta} and \code{hierDelta}, respectively.}

\item{betaCons}{A hierarchical data structure \code{\link[data.tree]{Node}} indicating t.p.m. constraints ('betaCons') among parameters in \code{hierBeta} at each level of the hierarchy.}

\item{deltaCons}{A hierarchical data structure \code{\link[data.tree]{Node}} indicating initial distribution constraints ('deltaCons') among parameters in \code{hierDelta} at each level of the hierarchy.}

\item{fixPar}{A list with elements named \code{'beta'} and/or \code{'delta'}, where each element is a hierarchical data structure \code{\link[data.tree]{Node}} indicating t.p.m. and initial distribution parameters in \code{hierBeta} and \code{hierDelta}, respectively, which are assumed known.}

\item{checkData}{logical indicating whether or not to check the suitability of \code{data} for the specified hierarchy. Ignored unless \code{data} is provided. Default: TRUE.}
}
\value{
A list of arguments needed for specifying a hierarchical HMM as a conventional HMM in \code{\link{fitHMM}} or \code{\link{MIfitHMM}}, including:
\item{nbStates}{See \code{\link{fitHMM}}.}
\item{dist}{See \code{\link{fitHMM}}.}
\item{formula}{See \code{\link{fitHMM}}.}
\item{formulaDelta}{See \code{\link{fitHMM}}.}
\item{beta0}{See \code{\link{fitHMM}}.}
\item{delta0}{See \code{\link{fitHMM}}.}
\item{betaRef}{See \code{\link{fitHMM}}.}
\item{betaCons}{See \code{\link{fitHMM}}.}
\item{deltaCons}{See \code{\link{fitHMM}}.}
\item{fixPar}{See \code{\link{fitHMM}}.}
\item{workBounds}{See \code{\link{fitHMM}}.}
\item{stateNames}{See \code{\link{fitHMM}}.}
}
\description{
Convert hierarchical HMM structure to a conventional HMM
}
