% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monad.R
\name{monad-laws}
\alias{monad-laws}
\title{Monad Laws}
\arguments{
\item{pure}{The function to wrap a value in the monad.}

\item{h, g}{Monadic functions. Functions that return monadic objects.}

\item{a}{Any object.}

\item{m}{A monadic object.}
}
\description{
Classes implementing \code{\link[=bind]{bind()}} are expected to satisfy three monad laws: left
identity, right identity, and associativity.
}
\details{
The Haskell monad laws can be translated into R as follows:

\describe{
\item{Left identity:}{\code{pure(a) \%>-\% h} is equal to \code{h(a)}.}
\item{Right identity:}{\code{m \%>-\% pure} is equal to \code{m}.}
\item{Associativity:}{\code{(m \%>-\% g) \%>-\% h} is equal to \verb{m \%>-\% \\(x) g(x) \%>-\% h}.}
}
}
\references{
\url{https://wiki.haskell.org/Monad_laws}
}
\seealso{
Other implementation laws: 
\code{\link{functor-laws}}
}
\concept{implementation laws}
