% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reproData.R
\name{plot.reproData}
\alias{plot.reproData}
\title{Plotting method for \code{reproData} objects}
\usage{
\method{plot}{reproData}(
  x,
  xlab,
  ylab = "Cumulated Number of offspring",
  main = NULL,
  concentration = NULL,
  style = "ggplot",
  pool.replicate = FALSE,
  addlegend = FALSE,
  remove.someLabels = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{reproData}}

\item{xlab}{label of the \eqn{X}-axis}

\item{ylab}{label of the \eqn{Y}-axis, by default \code{Cumulated Number of offspring}}

\item{main}{main title for the plot}

\item{concentration}{a numeric value corresponding to some concentration in
\code{data}. If \code{concentration = NULL}, draws a plot for each concentration}

\item{style}{graphical backend, can be \code{'ggplot'} or \code{'generic'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the \code{reproData} class.
It plots the cumulated number of offspring as a function of time.
}
\note{
When \code{style = "generic"}, the function calls the generic function
\code{\link[graphics]{plot}}

When \code{style = "ggplot"}, the function return an object of class
 \code{gg} and \code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
}
\keyword{plot}
