# mos: Simulation and Moments Computation for Order Statistics

The `mos` package provides tools for simulating order statistics, censored samples (Type I and Type II), and record values from various continuous distributions. It also includes functions to compute the moments (mean, variance, skewness, and kurtosis) of order statistics using exact or simulation-based methods.

## Installation

You can install the package from CRAN with:

```r
install.packages("mos")
```

## Features

- Simulation of order statistics from known or user-defined distributions via `ros()`.
- Generation of censored samples: `rcens()` and `rpcens2()`.
- Generation of upper and lower k-records: `rkrec()`.
- Moment computations for order statistics using closed-form or Monte Carlo methods:
  - Exact: `mo_unif()`, `mo_exp()`, `mo_weibull()`, etc.
  - Simulated: `mo_norm()`, `mo_gamma()`, `mo_beta()`, etc.

## Example

Compute the first and second moments of the 2nd order statistic from an exponential distribution:

```r
mo_exp(r = 2, n = 10, k = 1)  # First moment
mo_exp(r = 2, n = 10, k = 2)  # Second moment
```

Simulate order statistics from the normal distribution:

```r
ros(size = 5, r = 2, n = 10, dist = "norm", mean = 0, sd = 1)
```

## License

GPL-3
