% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ros}
\alias{ros}
\title{Generate Random Data from Order Statistics}
\usage{
ros(size, r, n, dist = NULL, qf = NULL, ...)
}
\arguments{
\item{size}{number of observations.}

\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{dist}{a character string specifying the name of a known distribution in R (e.g. \code{'norm'}, \code{'exp'}). Default is \code{NULL}.}

\item{qf}{a custom quantile function, either as a name (string) or directly as a function. Default is \code{NULL}.}

\item{...}{further arguments to be passed to \code{dist} or \code{qf}.}
}
\value{
A numeric vector or matrix containing the generated random data from the specified order statistics.
If a single rank is provided (i.e., scalar \code{r}), a numeric vector of size \code{size} is returned.
If multiple ranks are provided (i.e., vector \code{r}), a matrix is returned with \code{size} rows and
\code{length(r)} columns, where each row corresponds to a simulation and each column to an order statistic.
}
\description{
This function generates random data from the order statistics of a specified distribution.
The user can specify a known distribution in R or provide a custom quantile function.
}
\details{
The \code{ros} function generates random data from order statistics using two approaches:
\enumerate{
 \item \bold{Using a Known Distribution:} When \code{dist} is provided, random data is generated from a known distribution in R.
\item \bold{Using a Custom Quantile Function:} When \code{qf} is provided, \code{ros} applies
the user-provided quantile function to generate random data.
  }
}
\examples{
# Example 1: Generate from the normal distribution
ros(5, 3, 15, "norm", mean = 4, sd = 2)

# Example 2: Using a custom quantile function for the Pareto distribution
ros(3, 2, 10, qf = function(p, scale, shape) scale * (1 - p)^(-1 / shape), scale = 3, shape = 2)

# Example 3: Generate multiple order statistics from the uniform distribution
# In this example, first through 5th order statistics are generated from a sample size of 5.
ros(3, 1:5, 5, dist = "unif")

}
