% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps_critical_edges.R
\name{identify_gaps}
\alias{identify_gaps}
\title{List gaps}
\usage{
identify_gaps(net, motif, lvl_attr = c("sesType"), level = -1)
}
\arguments{
\item{net}{network object}

\item{motif}{motif identifier}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{level}{level of the dyads which shall be considered, or -1 if the level
shall be determined automatically.}
}
\value{
data frame with three columns, listing edges and their contribution
  to motifs described by the motif identifier in descending order
}
\description{
List gaps ordered by contribution to a motif. This is a list of ties together
with the number of motifs of a given class the dyad would generate by being
added to the network.
}
\details{
The level parameter determines on which level of the network gaps are
analysed. Per default, when ``level = -1``, the first level in the motif
which provides exactly two nodes is selected. Use this parameter to specify a
level manually. The procedure for determining the level is the same as for
the Actor's Choice Model, cf. vignette.

Note that this only works for undirected graphs. Regardless of whether the
input graph is directed it is treated as undirected graph.
}
\examples{
\dontrun{
head(identify_gaps(ml_net, motif = "1,2[II.C]"))
}
}
