% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_monotonic.R
\name{is_monotonic}
\alias{is_monotonic}
\title{Test if vector is monotonically in-/decreasing}
\usage{
is_monotonic(numeric_vector, decreasing = FALSE, strict = TRUE, warn = TRUE)
}
\arguments{
\item{numeric_vector}{Number sequence to-be checked.}

\item{decreasing}{Should the \code{numeric_vector} be increasing or decreasing?
Defaults to \code{FALSE}.}

\item{strict}{Must the values in-/decrease \emph{strictly}? Defaults to \code{TRUE},
indicating that a strict, not a weak definition of monotony is applied.}

\item{warn}{Will a warning be issued if the \code{numeric_vector} is not
monotonic? Defaults to \code{TRUE}.}
}
\value{
A length-one logical, indicating whether the vector is monotonic.
}
\description{
Checks if a \code{numeric_vector} is monotonically in-/decreasing.
In particular, it always a good idea to check the time stamps of trajectory
data and verify that the logging worked properly.
}
\details{
All objects of length 0 or 1 are monotonic. Data with missing
values will not pass the check.
}
\examples{

is_monotonic(c(1, 2, 3, 4), warn = FALSE)
is_monotonic(c(1, 2, 2, 3), warn = FALSE)
is_monotonic(c(1, 2, 2, 3), strict = FALSE, warn = FALSE)
is_monotonic(c(4, 0, -1, -1, -5),
  decreasing = TRUE,
  strict = FALSE, warn = FALSE
)

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
