% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{mt_heatmap_ggplot}
\alias{mt_heatmap_ggplot}
\title{Plot trajectory heatmap using ggplot.}
\usage{
mt_heatmap_ggplot(
  data,
  use = "trajectories",
  dimensions = c("xpos", "ypos"),
  use2 = "data",
  facet_row = NULL,
  facet_col = NULL,
  ...
)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{dimensions}{a character vector specifying the trajectory variables used
to create the heatmap. The first two entries are used as x and
y-coordinates, the third, if provided, will be added as color information.}

\item{use2}{an optional character string specifying where the data that
contain the variables used for faceting can be found (in case these
arguments are specified). Defaults to "data" as \code{data[["data"]]}
usually contains all non mouse-tracking trial data.}

\item{facet_row}{an optional character string specifying a variable in
\code{data[[use2]]} that should be used for (row-wise) faceting.}

\item{facet_col}{an optional character string specifying a variable in
\code{data[[use2]]} that should be used for (column-wise) faceting.}

\item{...}{arguments passed to \link{mt_heatmap_raw}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{mt_heatmap_ggplot} plots high resolution raw trajectory maps. Note that
this function has beta status.
}
\details{
\code{mt_heatmap_ggplot} wraps \link{mt_heatmap_raw} and returns a ggplot
object containing the plot. In contrast to \code{mt_heatmap_plot} plots
created by \code{mt_heatmap_ggplot} can be extended using ggplot's \code{+}
operator. For further details on how the trajectory heatmaps are constructed,
see \link{mt_heatmap_raw}.
}
\examples{
\dontrun{
mt_heatmap_ggplot(KH2017, xres=500, n_shades=5, mean_image=0.2)
}

}
\references{
Wulff, D. U., Haslbeck, J. M. B., Kieslich, P. J., Henninger, F.,
& Schulte-Mecklenbeck, M. (2019). Mouse-tracking: Detecting types in
movement trajectories. In M. Schulte-Mecklenbeck, A. Kühberger, & J. G.
Johnson (Eds.), \emph{A Handbook of Process Tracing Methods} (pp. 131-145). New York, NY:
Routledge.

Kieslich, P. J., Henninger, F., Wulff, D. U., Haslbeck, J. M. B., &
Schulte-Mecklenbeck, M. (2019). Mouse-tracking: A practical guide to
implementation and analysis. In M. Schulte-Mecklenbeck, A. Kühberger, & J.
G. Johnson (Eds.), \emph{A Handbook of Process Tracing Methods} (pp.
111-130). New York, NY: Routledge.
}
\seealso{
\link{mt_heatmap} for plotting a trajectory heatmap using base
plots.

\link{mt_diffmap} for plotting trajectory difference-heatmaps.
}
\author{
Pascal J. Kieslich

Felix Henninger

Dirk U. Wulff
}
