% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{autoplot.GrangerTime}
\alias{autoplot.GrangerTime}
\title{Plot a Granger S3 object}
\usage{
\method{autoplot}{GrangerTime}(object, splicing_df, lev_sig = 0.05, ...)
}
\arguments{
\item{object}{S3 object.}

\item{splicing_df}{Splicing data.frame object.}

\item{lev_sig}{significance level.}

\item{...}{ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
Plot a Granger S3 object
}
\examples{
r1 <- get_sample_recording()
fv_list <- get_filtered_views(r1, data_points = "Nose", n = 41, p = 3)
jv_sub <- get_joined_view(fv_list)
splicing_df <- splice_time(jv_sub, win_size = 3, step_size = 0.5)
sv <- get_spliced_view(jv_sub, splicing_df)
g <- granger_test(sv, "Nose_x_Central_Sitar", "Nose_x_Central_Tabla", lag = 3/25)
autoplot(g, splicing_df)
}
\seealso{
Other Granger Causality: 
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
