#' Synthetic dataset with a typical household survey design
#'
#' This is a synthetic dataset drawn from the Stata mpitb package. This is the data used in the provided examples.
#'
#' @name syn_cdta
#' @docType data
#' @author Nicolai Suppa
#' @references \doi{10.1177/1536867X231195286}
"syn_cdta"

#' Preprocessed Benin DHS 06 dataset
#'
#' The Benin DHS 06 dataset containing preprocessed data using the OPHI do-file from the Demographic and Health Survey (DHS) program.
#'
#' @name ben_dhs06
#' @docType data
#' @author OPHI
#' @source
#'  - DHS Program: https://ohss.dhs.gov/about-our-data
#'  - OPHI do-file: https://ophi.org.uk/global-mpi/2024
#' @references OPHI and UNDP (2024). Global Multidimensional Poverty Index 2024: Poverty amid conflict. United Nations Development Programme (UNDP) and Oxford Poverty and Human Development Initiative (OPHI), University of Oxford.
"ben_dhs06"

#' Preprocessed Benin DHS 17-18 dataset
#'
#' The Benin DHS 17-18 dataset containing preprocessed data using the OPHI do-file from the Demographic and Health Survey (DHS) program.
#'
#' @name ben_dhs17_18
#' @docType data
#' @author OPHI
#' @source
#'  - DHS Program: https://ohss.dhs.gov/about-our-data
#'  - OPHI do-file: https://ophi.org.uk/global-mpi/2024
#' @references OPHI and UNDP (2024). Global Multidimensional Poverty Index 2024: Poverty amid conflict. United Nations Development Programme (UNDP) and Oxford Poverty and Human Development Initiative (OPHI), University of Oxford.
"ben_dhs17_18"
