% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_likelihood.R
\name{fit_pl}
\alias{fit_pl}
\title{Maximum Pseudo-likelihood fitting of MRFs on 2d lattices.}
\usage{
fit_pl(
  Z,
  mrfi,
  family = "onepar",
  init = 0,
  optim_args = list(method = "BFGS"),
  return_optim = FALSE
)
}
\arguments{
\item{Z}{A \code{matrix} object containing the observed MRF. \code{NA} values can be
used to create a subregion of the lattice for non-rectangular data.}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{family}{The family of parameter restrictions to potentials. Families
are:
\code{'onepar'}, \code{'oneeach'}, \code{'absdif'}, \code{'dif'} or \code{'free'}.
See \code{\link[=mrf2d-family]{mrf2d-familiy}}.}

\item{init}{The initial value to be used in the optimization. It can be:
\itemize{
\item A valid \code{array} of parameter values according to \code{family}.
\item \code{0}. If set to \code{0} an array with `0`` in all entries is created.
}}

\item{optim_args}{Additional parameters passed to \code{optim()}.}

\item{return_optim}{\code{logical} indicating whether information from the
\code{optim()} call are returned.}
}
\value{
An object of class \code{mrfout} with elements:
\itemize{
\item \code{theta}: The estimated array of potential values.
\item \code{mrfi}: The interaction structure considered.
\item \code{family}: The parameter restriction family considered.
\item \code{method}: The estimation method (\code{"Pseudolikelihood"}).
\item \code{value}: The optimal pseudo-likelihood value.
\item \code{opt.xxx}(if \code{return_optim} is \code{TRUE}): Information returned by the
\code{optim()} function used for the optimization.
}
}
\description{
Parameter estimation for Markov random fields via
Pseudo-Likelihood function optimization. See
\code{\link[=pl_mrf2d]{pl_mrf2d}} for information on the
Pseudo-Likelihood function.
}
\examples{
fit_pl(Z_potts, mrfi(1), family = "onepar")
fit_pl(Z_potts, mrfi(1), family = "oneeach")
fit_pl(Z_potts, mrfi(2), family = "onepar")

}
\seealso{
A paper with detailed description of the package can be found at
\doi{10.18637/jss.v101.i08}.
}
\author{
Victor Freguglia
}
