% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream-write.R
\name{write_stream}
\alias{write_stream}
\alias{write_stream.default}
\alias{write_stream.stream_format_fst}
\alias{write_stream.stream_format_feather}
\alias{write_stream.stream_format_parquet}
\alias{write_stream.stream_format_qs}
\alias{write_stream.stream_format_rds}
\title{Writer functions for stream_file objects}
\usage{
write_stream(x, ...)

\method{write_stream}{default}(x, data, ...)

\method{write_stream}{stream_format_fst}(x, data, dir = NULL, ...)

\method{write_stream}{stream_format_feather}(x, data, dir = NULL, ...)

\method{write_stream}{stream_format_parquet}(x, data, dir = NULL, ...)

\method{write_stream}{stream_format_qs}(x, data, dir = NULL, ...)

\method{write_stream}{stream_format_rds}(x, data, dir = NULL, ...)
}
\arguments{
\item{x}{A \code{file_stream} object.}

\item{...}{Not used.}

\item{data}{An object to write.}

\item{dir}{An optional directory location to be used if not already in
the \code{file} spot in \code{x}.}
}
\value{
A logical value indicating if the output was written or not.
}
\description{
This function will write out objects that have been assigned a format
with either \code{\link[=format_stream]{format_stream()}} or the \code{format} argument to \code{\link[=new_stream]{new_stream()}}.
See examples.
}
\details{
The default method always returns \code{FALSE}; other methods which get invoked
if a \code{format} was set will return \code{TRUE}. So, the user can always call
\code{write_stream()} and check the return value: if \code{TRUE}, the file was written
to disk and the data to not need to be returned; a \code{FALSE} return value
indicates that no format was set and the data should be returned.

Note the write methods can be invoked directly for a specific format
if no \code{format} was set (see examples).
}
\examples{
ds <- temp_ds("example")

fs <- new_stream(2, locker = ds, format = "fst")

data <- data.frame(x = rnorm(10))

x <- lapply(fs, write_stream, data = data)

list.files(ds)

reset_locker(ds)

fs <- format_stream(fs, "rds")

x <- lapply(fs, write_stream, data = data)

list.files(ds)

}
\seealso{
\code{\link[=format_stream]{format_stream()}}, \code{\link[=ext_stream]{ext_stream()}}, \code{\link[=locate_stream]{locate_stream()}}, \code{\link[=new_stream]{new_stream()}},
\code{\link[=file_stream]{file_stream()}}
}
