% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir_ratio.R
\name{sir_ratio}
\alias{sir_ratio}
\alias{sir_ratio_lci}
\alias{sir_ratio_uci}
\title{Calculate Ratio of two SIRs or SMRs}
\usage{
sir_ratio(o1, o2, e1, e2)

sir_ratio_lci(o1, o2, e1, e2, alpha = 0.05)

sir_ratio_uci(o1, o2, e1, e2, alpha = 0.05)
}
\arguments{
\item{o1}{observed count for SIR 1}

\item{o2}{observed count for SIR 2}

\item{e1}{expected count for SIR 1}

\item{e2}{observed count for SIR 2}

\item{alpha}{alpha significance level for confidence interval calculations. Default is alpha = 0.05 which will give 95 percent confidence intervals.}
}
\value{
num numeric value of SIR / SMR estimate
}
\description{
Calculate ratio of two SIRs by providing observed and expected counts to \code{sir_ratio}
The related functions \code{sir_ratio_lci} and \code{sir_ratio_uci} can also calculate lower and upper estimates of the confidence interval
Calculations are based on formulas suggested by Breslow & Day 1987
}
\examples{
#provide the two expected and observed count to get the ratio of SIRs/SMRs
msSPChelpR::sir_ratio(o1 = 2140, o2 = 3158, e1 = 1993, e2 = 2123)

#calculate lower confidence limit
msSPChelpR::sir_ratio_lci(o1 = 2140, o2 = 3158, e1 = 1993, e2 = 2123, alpha = 0.05)

#calculate upper confidence limit
msSPChelpR::sir_ratio_uci(o1 = 2140, o2 = 3158, e1 = 1993, e2 = 2123, alpha = 0.05)

#functions can be easily used inside dplyr::mutate function
library(dplyr)
test_df <- data.frame(sir_oth = c(1.07, 1.36, 0.96), 
                  sir_smo = c(1.49, 1.81, 1.41),
                  observed_oth = c(2140, 748, 1392),
                  expected_oth = c(1993, 550, 1443),
                  observed_smo = c(3158, 744, 2414),
                  expected_smo = c(2123, 412, 1711))

test_df \%>\%
  mutate(smo_ratio = sir_ratio(observed_oth, observed_smo, expected_oth, expected_smo),
         smo_ratio_lci = sir_ratio_lci(observed_oth, observed_smo, expected_oth, expected_smo),
         smo_ratio_uci = sir_ratio_uci(observed_oth, observed_smo, expected_oth, expected_smo))
}
\references{
Breslow NE, Day NE. Statistical Methods in Cancer Research Volume II: The Design and Analysis of Cohort Studies. Lyon, France: IARC; 1987. (IARC Scientific Publications IARC Scientific Publications No. 82). Available from: http://publications.iarc.fr/Book-And-Report-Series/Iarc-Scientific-Publications/Statistical-Methods-In-Cancer-Research-Volume-II-The-Design-And-Analysis-Of-Cohort-Studies-1986
}
