% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{assert}
\alias{assert}
\title{Display an error, and record in a log file, if a condition is false}
\usage{
assert(
  condition,
  ...,
  level = 1,
  msg_level = getOption("msgr.level"),
  msg_types = getOption("msgr.types"),
  log_path = getOption("msgr.log_path")
)
}
\arguments{
\item{condition}{(boolean) The condition to check.}

\item{...}{(strings) message to be displayed or written to file.}

\item{level}{(integer, optional) The level of the message, from 1 to 10. Default: 1.}

\item{msg_level}{(integer, optional) The maximum level of messages to output. Default: set
in the option \code{"msgr.level"}.}

\item{msg_types}{(character, optional) The type to write or display. Must either NULL or one
or more from "INFO", "WARNING" or "ERROR". Default: set in the option \code{"msgr.types"}.}

\item{log_path}{(string, optional) The file path to the text log file. If set to "", then no
logs are written. Default: set in the option \code{"msgr.log_path"}.}
}
\value{
A string is return invisibly containing the error
}
\description{
This function calls the \code{\link[=error]{error()}} function to display an error if the specified condition
is false. If a message is not specified then a generic message is displayed.
}
\examples{
\dontrun{
  # Use assert() to create conditional timed errors
  x <- 1
  assert(x > 0, "Condition is true so this error is not shown")
  assert(x < 0, "Condition is false so this error is shown")

  # As with error() a level can be set
  assert(x < 0, "This is a level 2 error, so not shown by default", level = 2)

  # Set default level in options to determine what is shown
  options(msgr.level = 2)
  assert(x < 0, "This is a level 2 error, so is shown now", level = 2)
}

}
