% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_reg.R
\name{log_reg}
\alias{log_reg}
\title{A logistic regression DIF test for MSTs}
\usage{
log_reg(resp, DIF_covariate, theta = NULL)
}
\arguments{
\item{resp}{A data frame containing the response matrix. Rows correspond to respondents, columns to items.}

\item{DIF_covariate}{A factor indicating the membership to the reference and focal groups.}

\item{theta}{A vector of ability estimates for each respondent.}
}
\value{
A list with four elements. The first element is the response matrix, the second element is the name of
the DIF covariate, and the third element is the name of the test. The fourth element is a data frame where
each row corresponds to an item. The columns of this data frame correspond to the following entries:
\describe{
  \item{\code{N}}{The number of responses observed for this item.}
  \item{\code{overall_chi_sq}}{The chi squared statistic of the likelihood ratio test comparing Model 1 and Model 3.}
  \item{\code{overall_p_value}}{The p-values of the likelihood ratio test comparing Model 1 and Model 3 as
  an indicator for the overall DIF effect.}
  \item{\code{Delta_NagelkerkeR2}}{The difference of the Nagelkerke R squared values for Model 1 and Model 3.}
  \item{\code{UDIF_chi_sq}}{The chi squared statistic of the likelihood ratio test comparing Model 1 and Model 2.}
  \item{\code{UDIF_p_value}}{The p-values of the likelihood ratio test comparing Model 1 and Model 2.}
  \item{\code{UDIF_Delta_NagelkerkeR2}}{The difference of the Nagelkerke R squared values for Model 1 and Model 2.}
  \item{\code{CDIF_chi_sq}}{The chi squared statistic of the likelihood ratio test comparing Model 2 and Model 3.}
  \item{\code{CDIF_p_value}}{The p-values of the likelihood ratio test comparing Model 2 and Model 3.}
  \item{\code{CDIF_Delta_NagelkerkeR2}}{The difference of the Nagelkerke R squared values for Model 2 and Model 3.}
}
}
\description{
This function allows the detection of itemwise DIF for Multistage Tests. It is based on the comparison
of three logistic regression models for each item. The first logistic regression model (Model 1)
predicts the positiveness of each response solely on the estimated ability parameters. The second
logistic regression model (Model 2) predicts the positiveness based on the ability parameters
and the membership to the focal and reference group as additive predictor variables.
The third model (Model 3) uses the same predictors as Model 2 to predict the positiveness of the responses, but
also includes an interaction effect. Three model comparisons are carried out (Models 1/2, Models 1/3, Models 2/3)
based on two criteria: The comparison of the Nagelkerke R squared values, and the p-values of a likelihood ratio test.
}
\details{
Author: Sebastian Appelbaum, with minor changes by Rudolf Debelak and Dries Debeer
}
\examples{
data("toydata")
resp <- toydata$resp
group_categ <- toydata$group_categ
theta_est <- toydata$theta_est
log_reg(resp, DIF_covariate = factor(group_categ), theta = theta_est)


}
