% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate.mst}
\alias{generate.mst}
\title{Generates a MST graph}
\usage{
generate.mst(edges.complete.graph)
}
\arguments{
\item{edges.complete.graph}{A object of class "data.frame" with three columns (\emph{object_i}, \emph{object_j}, \emph{d_ij}) representing the distance \emph{d_ij} between \emph{object i} and \emph{object j} of the complete graph.}
}
\value{
A list with the elements
\item{edges.mst.graph}{A object of class "data.frame" with three columns (\emph{object_i}, \emph{object_j}, \emph{d_ij}) representing the distance \emph{d_ij} between object \emph{i} and object \emph{j} that are part of the MST graph.}
\item{mst.graph}{A object of class "igraph" which is the Minimal Spanning Tree (MST) graph generated.}
}
\description{
This function generates the Minimal Spanning Tree (MST) graph which is a connected and acyclic subgraph contains all the nodes of the complete graph (CG) and whose edges sum (distances) has minimum costs. Each node represents an object of the complete graph.
}
\details{
Generation of MST graph is performed using the Prim's algorithm.
}
\examples{

set.seed(1987)

##Generates a data matrix of dimension 50X13
n=50; m=13
x <- matrix(runif(n*m, min = -5, max = 10), nrow=n, ncol=m)

##Computes a distance matrix of x.

library("stats")
d <- base::as.matrix(stats::dist(x, method="euclidean"))

##Generates complete graph (CG)

cg <- generate.complete.graph(1:nrow(x),d)

##Generates MST graph

mstree <- generate.mst(cg)

##Visualizing MST graph
plot(mstree$mst.graph, main="MST")


}
\references{
Prim, R.C. (1957). \emph{Shortest connection networks and some generalizations}. Bell System Technical Journal, 37 1389-1401.

Ignatenkov, E. (2015). \emph{Minimum Spanning Tree (MST) for some graph using Prim's MST algorithm}. Stanford University course on Coursera.
}
\author{
Mario Inostroza-Ponta, Jorge Parraga-Alava, Pablo Moscato
}
\keyword{graph}
\keyword{mst}
