% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment_swap.R
\name{alignment_swap}
\alias{alignment_swap}
\title{Complete the alignment of initializations based on the output of function \code{\link{alignment_swap}}.}
\usage{
alignment_swap(L1, L2, initial_value_list)
}
\arguments{
\item{L1}{the component "L1" of the output from function \code{\link{alignment_swap}}}

\item{L2}{the component "L2" of the output from function \code{\link{alignment_swap}}}

\item{initial_value_list}{the output from function \code{\link{initialize}}}
}
\value{
A list with the following components (well-aligned).
\item{w}{the estimate of mixture proportion in GMMs for each task. Will be a vector.}
\item{mu1}{the estimate of Gaussian mean in the first cluster of GMMs for each task. Will be a matrix, where each column represents the estimate for a task.}
\item{mu2}{the estimate of Gaussian mean in the second cluster of GMMs for each task. Will be a matrix, where each column represents the estimate for a task.}
\item{beta}{the estimate of the discriminant coefficient for each task. Will be a matrix, where each column represents the estimate for a task.}
\item{Sigma}{the estimate of the common covariance matrix for each task. Will be a list, where each component represents the estimate for a task.}
}
\description{
Complete the alignment of initializations based on the output of function \code{\link{alignment_swap}}. This function is mainly for people to align the single-task initializations manually. The alignment procedure has been automatically implemented in function \code{mtlgmm} and \code{tlgmm}. So there is no need to call this function when fitting MTL-GMM or TL-GMM.
}
\note{
For examples, see part "fit signle-task GMMs" of examples in function \code{\link{mtlgmm}}.
}
\references{
Tian, Y., Weng, H., & Feng, Y. (2022). Unsupervised Multi-task and Transfer Learning on Gaussian Mixture Models. arXiv preprint arXiv:2209.15224.
}
\seealso{
\code{\link{mtlgmm}}, \code{\link{tlgmm}}, \code{\link{predict_gmm}}, \code{\link{data_generation}}, \code{\link{initialize}}, \code{\link{alignment}}, \code{\link{estimation_error}}, \code{\link{misclustering_error}}.
}
