% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_regressions}
\alias{plot_regressions}
\title{Plot differential regressions for a link}
\usage{
plot_regressions(
  deggs_object,
  assayDataName = 1,
  gene_A,
  gene_B,
  title = NULL,
  legend_position = "topright"
)
}
\arguments{
\item{deggs_object}{an object of class \code{deggs} generated by
\code{get_diffNetworks}}

\item{assayDataName}{name of the assayData of interest. If an unnamed list of
data was given to \code{get_diffNetworks}, the assayDataName here will be the
number indicating the position of the data in the assayDataList provided
before (i.e. if the user wants to plot a differential interaction observed in
the transcriptomic data, which was second in the list, then assayDataName
must be 2, if only one data table was provided assayDataName must be 1).
Default 1.}

\item{gene_A}{character. Name of the first target (gene, protein, metabolite,
etc.)}

\item{gene_B}{character. Name of the second target (gene, protein, metabolite,
etc.)}

\item{title}{plot title. If NULL (default), the name of the assayData will be
used. Use empty character "" for no title.}

\item{legend_position}{position of the legend in the plot. It can be
specified by keyword or in any parameter accepted by \code{xy.coords} (defalut
"topright")}
}
\value{
base graphics plot showing differential regressions across
categories. The p value of the interaction term of
gene A ~ gene B \* category is reported on top.
}
\description{
Plot differential regressions for any target-target pair in an omic dataset
}
\examples{
data("synthetic_metadata")
data("synthetic_rnaseqData")
data("synthetic_proteomicData")
data("synthetic_OlinkData")
assayData_list <- list("RNAseq" = synthetic_rnaseqData,
                       "Proteomics" = synthetic_proteomicData,
                       "Olink" = synthetic_OlinkData)
deggs_object <- get_diffNetworks(assayData = assayData_list,
                                 metadata = synthetic_metadata,
                                 category_variable = "response",
                                 regression_method = "lm",
                                 padj_method = "bonferroni",
                                 verbose = FALSE,
                                 show_progressBar = FALSE,
                                 cores = 1)
plot_regressions(deggs_object,
                 assayDataName = "RNAseq",
                 gene_A = "MTOR", 
                 gene_B = "AKT2",
                 legend_position = "bottomright")
}
