% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DesignSelection.R
\name{optMultiCrit}
\alias{optMultiCrit}
\title{Selection of a symmetrical design on the Pareto Front based on the utopian point}
\usage{
optMultiCrit(ar, ...)
}
\arguments{
\item{ar}{A list as the \code{megaAR} list returned by \code{\link[multiDoE]{runTPLS}}.}

\item{...}{optional argument (see below).}
}
\value{
The \code{optMultiCrit} function returns a list whose elements are:
\itemize{
\item \code{solution}: The selected optimal design matrix.
\item \code{score}: A vector containing the criteria scores for \code{solution}.
}
}
\description{
The \code{optMultiCrit} function provides an objective criterion
for the selection of the best experimental design among all Pareto front solutions.
The selection is based on minimizing the euclidean distance in the criteria space
between all the Pareto front points and an approximate utopian point. By default,
the coordinates of the utopian point correspond to the minimum value reached
by each criterion during the \code{\link[multiDoE]{runTPLS}} optimization procedure.
Alternatively, the utopian point can be chosen by the user.
}
\details{
Additional arguments can be specified as follows:
\itemize{
\item \code{myUtopianPoint}: A vector containing the utopian point coordinates.
}
}
