% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{file_content}
\alias{file_content}
\title{Retrieve the content of a file from a GitHub repository}
\usage{
file_content(repo, path, ref = NULL)
}
\arguments{
\item{repo}{Character string specifying the full name of the repository (format: "owner/repo")}

\item{path}{Character string specifying the path to the file within the repository}

\item{ref}{Character string specifying the branch name, tag, or commit SHA. Default is NULL (uses default branch).}
}
\value{
When successful, returns a \code{list} with two elements:

\describe{
\item{content}{Character string containing the decoded file content}
\item{sha}{Character string with the file's blob SHA for use in update operations}
}

When the file cannot be retrieved (e.g., does not exist or no access), returns \code{NULL}.
}
\description{
This function fetches a file from a GitHub repository and returns its content and SHA.
If the file cannot be retrieved, it returns NULL and optionally displays a warning message.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get content from default branch
file_info <- file_content("username/repository", "path/to/file.R")
if (!is.null(file_info)) {
  # Access the content and SHA
  content <- file_info$content
  sha <- file_info$sha
}

# Get content from specific branch
file_info <- file_content("username/repository", "path/to/file.R", ref = "develop")

# Suppress warnings
file_info <- file_content("username/repository", "path/to/file.R")
\dontshow{\}) # examplesIf}
}
