% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifamm.R
\name{multiFAMM}
\alias{multiFAMM}
\title{Multivariate Functional Additive Mixed Model Regression}
\usage{
multiFAMM(data, fRI_B = FALSE, fRI_C = FALSE, nested = FALSE,
  bs = "ps", bf_mean = 8, bf_covariates = 8, m_mean = c(2, 3),
  covariate = FALSE, num_covariates = NULL, covariate_form = NULL,
  interaction = FALSE, which_interaction = matrix(NA), bf_covs, m_covs,
  var_level = 1, use_famm = FALSE, save_model_famm = FALSE,
  one_dim = NULL, mfpc_weight = FALSE, mfpc_cutoff = 0.95,
  number_mfpc = NULL, mfpc_cut_method = c("total_var", "unidim"),
  final_method = c("w_bam", "bam", "gaulss"), weight_refit = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{data}{Data.table that contains the information with some fixed variable
names, see Details.}

\item{fRI_B}{Boolean for including functional random intercept for individual
(B in Cederbaum). Defaults to \code{FALSE}.}

\item{fRI_C}{Boolean for including functional random intercept
for word (C in Cederbaum). Defaults to \code{FALSE}.}

\item{nested}{\code{TRUE} to specify a model with nested functional random
intercepts for the first and second grouping variable and a smooth error
curve. Defaults to \code{FALSE}.}

\item{bs}{Spline basis function, only tested for "ps" (as in sparseFLMM).}

\item{bf_mean}{Basis dimension for functional intercept (as in sparseFLMM).}

\item{bf_covariates}{Basis dimension for all covariates (as in sparseFLMM).}

\item{m_mean}{Order of penalty for basis function (as in sparseFLMM).}

\item{covariate}{Covariate effects (as in sparseFLMM).}

\item{num_covariates}{Number of covariates included in the model (as in
sparseFLMM).}

\item{covariate_form}{Vector of strings for type of covariate (as in
sparseFLMM).}

\item{interaction}{TRUE if there are interactions between covariates (as in
sparseFLMM). Defaults to \code{FALSE}.}

\item{which_interaction}{Symmetric matrix specifying the interaction terms
(as in sparseFLMM).}

\item{bf_covs}{Vector of marginal basis dimensions for fRI covariance
estimation (as in sparseFLMM).}

\item{m_covs}{List of marginal orders for the penalty in fRI covariance
estimation (as in sparseFLMM).}

\item{var_level}{Pre-specified level of explained variance on each
dimension (as in sparseFLMM). Defaults to including all non-negative
Eigenvalues.}

\item{use_famm}{Re-estimate the mean in FAMM context (as in sparseFLMM) -
overwritten by one_dim.}

\item{save_model_famm}{Give out the FAMM model object (as in sparseFLMM) -
overwritten by one_dim.}

\item{one_dim}{Specify the name of the dimension if sparseFLMM is to be
computed only on one dimension.}

\item{mfpc_weight}{TRUE if the estimated univariate error variance is to be
used as weights in the scalar product of the MFPCA.}

\item{mfpc_cutoff}{Pre-specified level of explained variance of results of
MFPCA. Defaults to 0.95.}

\item{number_mfpc}{List containing the number of mfPCs needed for each
variance component e.g. list("E" = x, "B" = y).}

\item{mfpc_cut_method}{Method to determine the level of explained variance
\itemize{
  \item total_var: (weighted) sum of variation over the dimensions.
  \item unidim: separate on each dimension.
}}

\item{final_method}{Function used for estimation of final model to allow for
potential heteroscedasticity ("w_bam", "bam", "gaulss").}

\item{weight_refit}{Get the weights for the weighted bam by first refitting
the model under an independence assumption but with mfpc basis functions.
Defaults to FALSE.}

\item{verbose}{Print progress of the multifamm. Defaults to TRUE.}

\item{...}{Additional arguments to be passed to (mainly) the underlying
sparseFLMM function.}
}
\value{
A list with five elements
  \itemize{
    \item the final multivariate FAMM
    \item the sparseFLMM output for each of the dimensions
    \item information on the untruncated MPFCA results
    \item the truncated MFPC output
    \item the data used to fit the model.}
}
\description{
This is the main function of the package and fits the multivariate functional
additive regression model with potentially nested or crossed functional
random intercepts.
}
\details{
Expand the method proposed by Fabian Scheipl to incorporate the variance
decomposition developed by Cederbaum et al. (2016). To account for the
correlation between the dimensions, the MFPCA approach by Happ and Greven
(2016) is applied.

The data set has to be of the following format:
\itemize{
  \item y_vec (numeric): vector of response values
  \item t (numeric): observation point locations
  \item n_long (integer): curve identification
  \item subject_long (integer): subject identification (NEEDS TO BE
    SPECIFIED)
  \item word_long (integer): word identification
  \item combi_long (integer): repetition
  \item dim (factor): level of the dimension
  \item covariate.1 (numeric): potential covariate(s) named with trailing
    1,2,3,...
}

It is possible to introduce weights for the final estimation of the
multiFAMM. Currently, it is only implemented to use the inverse of the
univariate measurement error estimates as weights. Note that negative
values of variance estimates are set to zero in fast symmetric additive
covariance smoothing. In order to still include weights, zero-values are
substituted by values of the smallest positive variance estimate.
}
\examples{

# subset of the phonetic data (very small subset, no meaningful results can
# be expected and no random effects other than the random smooth should be
# included in the model)

data(phonetic_subset)

m <- multiFAMM(data = phonetic_subset, covariate = TRUE, num_covariates = 2,
               covariate_form = c("by", "by"), interaction = TRUE,
               which_interaction = matrix(c(FALSE, TRUE, TRUE, FALSE),
               nrow = 2, ncol = 2), bf_covs = c(5), m_covs = list(c(2, 3)),
               mfpc_cut_method = "total_var", final_method = "w_bam")

}
