% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_raster.R
\name{check_raster}
\alias{check_raster}
\title{Check input raster}
\usage{
check_raster(raster, verbose = TRUE)
}
\arguments{
\item{raster}{An object of class 'RasterLayer', 'RasterStack', 'RasterBrick', 'SpatRaster',
or a list of raster objects (one of 'RasterLayer' or 'SpatRaster').}

\item{verbose}{Print warning messages in the console? Default is TRUE.}
}
\value{
A data frame with relevant information about the inputted raster.
}
\description{
Checks the validity of raster layers to be inputted in \code{\link[=mland]{mland()}}, intended to represent land cover. The function directly calls
\code{\link[landscapemetrics:check_landscape]{landscapemetrics::check_landscape()}}.
}
\details{
Extracts basic information about the inputted raster: coordinate reference system (crs) - either "geographic",
"projected", or NA, units of the
coordinate reference system, class for the values of the inputted raster and the number of classes
found in the raster.
}
