% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{predict.brmcoda}
\alias{predict.brmcoda}
\alias{predict}
\title{Draws from the Posterior Predictive Distribution}
\usage{
\method{predict}{brmcoda}(object, scale = c("linear", "response"), parts = 1, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{scale}{Specifically for models with compositional responses,
either \code{"response"} or \code{"linear"}.
If \code{"linear"},
results are returned on the log-ratio scale.
If \code{"response"}, results are returned on the compositional scale
of the response variable.}

\item{parts}{Only for models with compositional response
A optional character string specifying names of compositional parts that make up the response in \code{brmcoda} model.
This should correspond to a single set of names of compositional parts specified
in the \code{complr} object. Default to the first composition in the \code{complr} object.}

\item{...}{Further arguments passed to \code{\link[brms:predict.brmsfit]{predict.brmsfit}}
that control additional aspects of prediction.}
}
\value{
An \code{array} of predicted response values.
  If \code{summary = FALSE} the output resembles those of
  \code{\link[brms]{posterior_predict.brmsfit}}.

  If \code{summary = TRUE} the output depends on the family: For categorical
  and ordinal families, the output is an N x C matrix, where N is the number
  of observations, C is the number of categories, and the values are
  predicted category probabilities. For all other families, the output is a N
  x E matrix where E = \code{2 + length(probs)} is the number of summary
  statistics: The \code{Estimate} column contains point estimates (either
  mean or median depending on argument \code{robust}), while the
  \code{Est.Error} column contains uncertainty estimates (either standard
  deviation or median absolute deviation depending on argument
  \code{robust}). The remaining columns starting with \code{Q} contain
  quantile estimates as specified via argument \code{probs}.
}
\description{
Compute posterior draws of the posterior predictive distribution
of a \code{brmsfit} model in the \code{brmcoda} object.
Can be performed for the data used to fit the model (posterior predictive checks) or
for new data. By definition, these draws have higher variance than draws
of the expected value of the posterior predictive distribution computed by
\code{\link{fitted.brmcoda}}. This is because the residual error
is incorporated in \code{posterior_predict}. However, the estimated means of
both methods averaged across draws should be very similar.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  ## fit a model
  x <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                 idvar = "ID", total = 1440)

  m1 <- brmcoda(complr = x,
                formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                   wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")

  ## predicted responses
  pred <- predict(m1)
  head(pred)

  ## fit a model with compositional outcome
  m2 <- brmcoda(complr = x,
                formula = mvbind(z1_1, z2_1, z3_1, z4_1) ~ 
                          bz1_1 + bz2_1 + bz3_1 + bz4_1 + Female + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")

  ## predicted responses on ilr scale
  predilr <- predict(m2, scale = "linear")
  head(predilr)

  ## predicted responses on compositional scale
  predcomp <- predict(m2, scale = "response")
  head(predcomp)
}}
}
\seealso{
\code{\link[brms:predict.brmsfit]{predict.brmsfit}}
}
