% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{edges}
\alias{edges}
\title{Graphical Structure for Mediation Objects}
\usage{
edges(object)
}
\arguments{
\item{object}{An object whose DAG structure we want to access.}
}
\value{
The output depends on the S4 object that is passed. For multimedia
objects, this will return an edgelist as a two column data.frame.
}
\description{
We often want to access the DAG for different mediation-related S4 objects.
This generic helps us access these graphical model edges lists. See method
instantiations for specific examples.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    edges()
}
