% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{indirect_overall}
\alias{indirect_overall}
\title{Overall Indirect Effect}
\usage{
indirect_overall(model, exper = NULL, t1 = 1, t2 = 2)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}

\item{t1}{The reference level of the treatment to be used when computing the
indirect effect.}

\item{t2}{The alternative level of the treatment to be used when computing
the indirect effect.}
}
\value{
A data.frame summarizing the overall indirect effects associated with
different settings of j in the equation above.
}
\description{
Direct Effects from Estimated Model
}
\details{
Estimate direct effects associated with a multimedia model. These estimates
are formed using Equation (10) of our preprint.
}
\examples{
# example with null data
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
fit <- multimedia(exper) |>
    estimate(exper)

indirect_overall(fit)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
fit <- multimedia(exper) |>
    estimate(exper)
indirect_overall(fit)
}
