% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{lnm_model}
\alias{lnm_model}
\title{Logistic Normal Multinomial Model}
\usage{
lnm_model(...)
}
\arguments{
\item{...}{Keyword parameters passed to lnm in the 'miniLNM' package.}
}
\value{
model An object of class \code{model} with estimator, predictor, and
sampler functions associated wtih a linear model.
}
\description{
Apply a logistic normal multinomial model to jointly model a vector of count
responses $y$ in an outcome or mediation model. This is a common choice for
data where the parameter of interest is the composition across responses
(e.g., microbiome).
}
\examples{
m <- lnm_model()
mat <- data.frame(matrix(rpois(250, 10), 25, 10))
colnames(mat) <- paste0("y", seq_len(6))
fit <- estimator(m)(y1 + y2 + y3 + y4 ~ y5 + y6, mat)
}
\seealso{
model lm_model rf_model glmnet_model brms_model
}
