% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{treatments<-,mediation_data-method}
\alias{treatments<-,mediation_data-method}
\title{Set the Treatments in a Mediation Data Object}
\usage{
\S4method{treatments}{mediation_data}(object) <- value
}
\arguments{
\item{object}{An object of class mediation_data.}

\item{value}{The new treatment values for the object.}
}
\value{
A version of \code{object} whose treatment slot has been replaced.
}
\description{
This is an setter method for the treatments slot in a mediation data object.
It lets you supply a new treatments data.frame for the object.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
treatments(exper) <- data.frame(t = rep(0, 10))
exper
}
