% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initParamList.R
\name{initParamList}
\alias{initParamList}
\title{Initialise the parameter list.}
\usage{
initParamList(D, Z)
}
\arguments{
\item{D}{an object of class \code{multimixSettings}---see
\code{\link{data_organise}} for details.}

\item{Z}{an \eqn{n \times q}{n by q} matrix, where \eqn{n}{n} is the number
of rows of \code{dframe} and \eqn{q}{q} is the number of components in the
mixture. During the fitting \eqn{Z_{ij}}{Zij} holds the currently estimated
probability that observation \eqn{i}{i} belongs to component \eqn{j}{j}.
Often \code{Z} is initialized to a matrix of indicator columns for a
partition of the data. It is also common to initialize \code{Z} to be the
final \code{Z} from the fitting of a simpler model.}
}
\value{
an object of class \code{multimixParamList} which is a \code{list} 
with the following elements:
\itemize{
   \item{\code{dstat}}{ -- \code{list} of matrices for each discrete variable
    not included in a location model. The matrix for each discrete variable 
    is made up of a column of length \eqn{q}{q} for each level (value) of the 
    variable giving the expected proportion of each level (column) for each 
    mixture component (row). Rows sum to 1.}
   \item{\code{ldstat}}{ -- \code{list} of matrices for each discrete 
   variable within a location model. The matrix for each discrete variable is
    made up of a column of length \eqn{q}{q} for each level (value) of the 
    variable giving the expected proportion of each level (column) for each 
    mixture component (row). Rows sum to 1. }
   \item{\code{ostat}}{ -- \code{matrix}  with a column for each continuous 
   variable outside any location mode whose \eqn{q}{q} rows give the current 
   estimated mean for each mixture component. }
   \item{\code{ostat2}}{ -- \code{matrix} with a column for each continuous 
   variable outside any location mode whose \eqn{q}{q}rows give the current 
   estimated mean square for each mixture component. }
   \item{\code{osvar}}{ -- \code{matrix} with a column for each continuous
    variable outside any location mode whose \eqn{q}{q} rows give the current
     estimated variance for each mixture component. }
   \item{\code{cstat}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, that is not including discrete cells or 
   cells listed in lcdep, each member being a \code{matrix} with a column for each 
   continuous variable in that cell, whose \eqn{q}{q} rows give the current 
   estimated mean for each mixture component. }
   \item{\code{cstat2}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, each member being a \code{matrix} with a column
    for each continuous variable in that cell, whose \eqn{q}{q} rows give the 
    current estimated mean square for each mixture component. }
   \item{\code{cvar}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, each member being a \code{matrix} with a column
    for each continuous variable in that cell, whose \eqn{q}{q} rows give the 
    current estimated variance for each mixture component. }
   \item{\code{cpstat}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, each member being the \code{matrix} with rows 
   for each of the \eqn{q}{q} mixture components and columns for each pair of 
   continuous variables in that cell, as ordered by \code{\link{pair.index}}. 
   The matrix 
   elements are the currently expected products of the variable pairs 
   arranged by component and pair. }
   \item{\code{ccov}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, each member being the \code{matrix} with rows 
   for each of the \eqn{q}{q} mixture components and columns for each pair of 
   continuous variables in that cell, as ordered by pair.index. The matrix 
   elements are the currently expected covariances of the variable pairs 
   arranged by component and pair.}
   \item{\code{MVMV}}{ -- \code{list} with a member for each nontrivial, 
   fully continuous, partition cell, each member being a list with members 
   for each of the \eqn{q}{q} mixture components whose values are the 
   covariance matrix estimates for that cell and component. }
   \item{\code{lcstat}}{ -- \code{list} with a member for location partition 
   cell, each member being a \code{matrix} with a column for each continuous 
   variable in that cell, whose \eqn{q}{q} rows give the current estimated
    mean for each mixture component. }
   \item{\code{lcstat2}}{ -- \code{list} with a member for location partition
    cell, each member being a \code{matrix} with a column for each continuous 
    variable in that cell, whose \eqn{q}{q} rows give the current estimated 
    mean square for each mixture component. }
   \item{\code{lcpstat}}{ -- \code{list} with a member for each location 
   cell, each member being the \code{matrix} with rows for each of the 
   \eqn{q}{q} mixture components and columns for each pair of continuous 
   variables in that cell, as ordered by \code{\link{pair.index}}. The matrix 
   elements are the currently expected products of the variable pairs 
   arranged by component and pair. }
   \item{\code{lccov}}{ -- \code{list} with a member for each location cell, 
   each member being the matrix with rows for each of the \eqn{q}{q} mixture 
   components and columns for each pair of continuous variables in that cell,
    as ordered by \code{\link{pair.index}}. The matrix elements are the 
    currently estimated covariances of the variable pairs arranged by 
    component and pair. }
   \item{\code{ldxcstat}}{ -- \code{list} with a member for each location 
   partition cell, each member being a list with a member for each level of 
   the cell's discrete variable that member being a matrix of mean values of 
   the continuous variables for each level-class combination. }
   \item{\code{pistat}}{ -- \code{vector} containing estimates of population 
   proportion in each cluster; column means of \eqn{Z}{Z} matrix.}
   \item{\code{W}}{ -- \code{matrix} of weights of observation \eqn{i}{i} in 
   cluster \eqn{j}{j}; the columns of the \eqn{Z}{Z} matrix are each 
   multiplied by constant to give \eqn{W}{W} columns summing to 1.}
}
}
\description{
Although the starting parameter list \code{P} may be specified directly, 
Note also that any matrices specified must be positive definite.
This function calculates an initial \code{P} from \code{D} and a starting
value for \code{Z}.
}
