% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_projector_union.R
\name{bi_projector_union}
\alias{bi_projector_union}
\title{A Union of Concatenated \code{bi_projector} Fits}
\usage{
bi_projector_union(fits, outer_block_indices = NULL)
}
\arguments{
\item{fits}{A list of \code{bi_projector} instances with the same row space. These instances
will be combined to create a new \code{bi_projector} instance.}

\item{outer_block_indices}{An optional list of indices for the outer blocks. If not provided,
the function will compute the indices based on the dimensions of the input fits.}
}
\value{
A new \code{bi_projector} instance with concatenated weights, scores, and other
properties from the input \code{bi_projector} instances.
}
\description{
This function combines a set of \code{bi_projector} fits into a single \code{bi_projector} instance.
The new instance's weights and associated scores are obtained by concatenating the weights
and scores of the input fits.
}
\examples{

X1 <- matrix(rnorm(5*5), 5, 5)
X2 <- matrix(rnorm(5*5), 5, 5)

bpu <- bi_projector_union(list(pca(X1), pca(X2)))

}
