% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiblock.R
\name{multiblock_biprojector}
\alias{multiblock_biprojector}
\title{Create a Multiblock Bi-Projector}
\usage{
multiblock_biprojector(
  v,
  s,
  sdev,
  preproc = prep(pass()),
  ...,
  block_indices,
  classes = NULL
)
}
\arguments{
\item{v}{A matrix of components with dimensions \code{nrow(v)} by \code{ncol(v)} (number of columns = number of components).}

\item{s}{A matrix of scores.}

\item{sdev}{A numeric vector of singular values.}

\item{preproc}{A pre-processing function for the data (default is a pass-through with \code{prep(pass())}).}

\item{...}{Extra arguments.}

\item{block_indices}{A list of numeric vectors specifying the indices of each data block.}

\item{classes}{(optional) A character vector specifying the class attributes of the object, default is NULL.}
}
\value{
A \code{multiblock_biprojector} object.
}
\description{
Constructs a multiblock bi-projector using the given component matrix (\code{v}), score matrix (\code{s}), singular values (\code{sdev}),
a preprocessing function, and a list of block indices. This allows for the projection of multiblock data, where each block
represents a different set of variables or features, with two-way mapping from samples to scores and from variables to components.
}
\seealso{
bi_projector, multiblock_projector
}
