% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composed_projector.R
\name{print.composed_projector}
\alias{print.composed_projector}
\title{Pretty Print Method for \code{composed_projector} Objects}
\usage{
\method{print}{composed_projector}(x, ...)
}
\arguments{
\item{x}{A \code{composed_projector} object.}

\item{...}{Additional arguments passed to \code{print()}.}
}
\value{
The \code{composed_projector} object.
}
\description{
Display a human-readable summary of a \code{composed_projector} object, including information about the number and order of projectors.
}
\examples{
# Create two PCA projectors and compose them
X <- matrix(rnorm(20*20), 20, 20)
pca1 <- pca(X, ncomp=10)
X2 <- scores(pca1)
pca2 <- pca(X2, ncomp=4)
cproj <- compose_projectors(pca1, pca2)
}
