% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{frequencize}
\alias{frequencize}
\title{Convert Mutation COunts to PerMille Frequencies.}
\usage{
frequencize(countMatrix, permille = TRUE)
}
\arguments{
\item{countMatrix}{numeric matrix of mutation counts}

\item{permille}{ligucal, shall the permille conversion be used instead of the standard frequency}
}
\value{
list including colSums (mutation burden of each sample) and freqs (matrix of frequencies)
}
\description{
Convert Mutation COunts to frequencies. Typically, a permille frequence is returned.
In other words, the resulting number indicates the expected mutation count if the genome hat a 
total of 1000 mutations. This way, the MutSignatures analysis will be
less biased toward the hyper-mutator samples.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
A <- cbind(c(7, 100, 90, 1000), c(1, 3, 5, 9))
fA <- mutSignatures::frequencize(A)
fA$freqs
 
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
