% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_types.R
\name{select_most_severe_consequence_so}
\alias{select_most_severe_consequence_so}
\title{Select the most severe consequence (SO)}
\usage{
select_most_severe_consequence_so(so_mutation_types, missing_is_valid = FALSE)
}
\arguments{
\item{so_mutation_types}{a character vector of SO terms, where multiple so_mutation_types per field are & delimited, and you want to choose the most severe consequence .}

\item{missing_is_valid}{should NA values be considered valid mutation classes or should they throw an error? (flag)}
}
\value{
the most severe consequence for each element in so_mutation_types
}
\description{
Take a character vector which may contain multiple so mutation types separated by '&'
And choose only the most severe consequence
}
\examples{
select_most_severe_consequence_so(
 c(
   "intergenic_variant&feature_truncation&splice_acceptor_variant",
   "initiator_codon_variant&inframe_insertion"
 )
)
#> Result:
#> c("splice_acceptor_variant", "initiator_codon_variant")
}
