% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_Lorenz_noise.R
\name{simulate_Lorenz_noise}
\alias{simulate_Lorenz_noise}
\title{Simulate the Lorenz System with noise}
\usage{
simulate_Lorenz_noise(
  N = 1000,
  delta_t = NULL,
  tmax = 50,
  X0 = 0,
  Y0 = 1,
  Z0 = 1,
  sdX = NULL,
  sdY = NULL,
  sdZ = NULL,
  sdnoiseX,
  sdnoiseY,
  sdnoiseZ,
  s = 10,
  r = 28,
  b = 8/3,
  naive = FALSE,
  return_time = TRUE
)
}
\arguments{
\item{N}{Length of Times Series}

\item{delta_t}{Step size for time scale. If \code{NULL} this is derived using \code{N} and \code{tmax}. \code{DEFAULT} to \code{NULL}.}

\item{tmax}{Upper bound of the time scale. This argument is ignored if \code{delta_t} is provided. \code{DEFAULT} to \code{50}.}

\item{X0}{Initial value for X at t=0. \code{DEFAULT} to 0.}

\item{Y0}{Initial value for Y at t=0. \code{DEFAULT} to 1.}

\item{Z0}{Initial value for Z at t=0. \code{DEFAULT} to 1.}

\item{sdX}{Use this argument to rescale the X-coordinate to have the desired standard deviation (exactly). This is ignored if set to \code{NULL}. \code{DEFAULT} to \code{NULL}.}

\item{sdY}{Use this argument to rescale the Y-coordinate to have the desired standard deviation (exactly). This is ignored if set to \code{NULL}. \code{DEFAULT} to \code{NULL}.}

\item{sdZ}{Use this argument to rescale the Z-coordinate to have the desired standard deviation (exactly). This is ignored if set to \code{NULL}. \code{DEFAULT} to \code{NULL}.}

\item{sdnoiseX}{Standard deviation of Gaussian noise of X-coordinate. If set to \code{0}, no noise is created.}

\item{sdnoiseY}{Standard deviation of Gaussian noise of Y-coordinate. If set to \code{0}, no noise is created.}

\item{sdnoiseZ}{Standard deviation of Gaussian noise of Z-coordinate. If set to \code{0}, no noise is created.}

\item{s}{s-parameter of the Lorenz ODE. See Vignette for further details. \code{DEFAULT} to \code{10}, which is the original value chosen by Lorenz.}

\item{r}{r-parameter of the Lorenz ODE. See Vignette for further details. \code{DEFAULT} to \code{28}, which is the original value chosen by Lorenz.}

\item{b}{b-parameter of the Lorenz ODE. See Vignette for further details. \code{DEFAULT} to \code{8/3}, which is the original value chosen by Lorenz.}

\item{naive}{Logical whether naive calculation should be used. \code{DEFAULT} to \code{FALSE}.}

\item{return_time}{Logical whether the time-coordinate should be included in the returned \code{data.frame}. \code{DEFAULT} to \code{TRUE}.}
}
\value{
Returns a three dimensional time series as \code{data.frame} following the Lorenz system (Lorenz, 1963, <doi:10.1175/1520-0469(1963)020<0130:DNF>2.0.CO;2>).
}
\description{
Simulate the Lorenz System with noise
}
\references{
Lorenz, E. N. (1963). Deterministic nonperiodic flow. Journal of atmospheric sciences, 20(2), 130-141. <doi:10.1175/1520-0469(1963)020<0130:DNF>2.0.CO;2>
}
