% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_early_conservation_test.R
\name{stat_early_conservation_test}
\alias{stat_early_conservation_test}
\title{Early Conservation Test}
\usage{
stat_early_conservation_test(phyex_set, modules, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A ConservationTestResult object with early conservation test results
}
\description{
Test for early conservation patterns in transcriptomic data by comparing
early developmental stages to mid and late stages.
}
\details{
The early conservation test evaluates whether early developmental stages show
lower transcriptomic index values (indicating older genes) compared to later
stages. The test computes a score based on the minimum difference between
mid vs. early and late vs. early TXI values.
}
\examples{
# Define developmental modules
p <- example_phyex_set_old |> 
     select_genes(example_phyex_set_old@gene_ids[1:100])
modules <- list(early = 1:2, mid = 3:5, late = 6:7)
result <- stat_early_conservation_test(p, modules=modules)

}
\seealso{
\code{\link{stat_generic_conservation_test}}, \code{\link{stat_late_conservation_test}}
}
