% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Perfomance_simulation.R
\name{performance_simulation}
\alias{performance_simulation}
\title{Performance indexes}
\usage{
performance_simulation(
  states,
  beta,
  eta,
  likelihood = NA,
  questioning_rule = "half_split",
  nrep = 1
)
}
\arguments{
\item{states}{A state-by-problem matrix representing the structure, where an element is one if the item is included in the state, and zero otherwise.}

\item{beta}{Vector of careless error probabilities.}

\item{eta}{Vector of lucky guess error probabilities.}

\item{likelihood}{A vector of the likelihood for each state, if omitted the initial likelihood is assumed equally distributed.}

\item{questioning_rule}{A function which is used a questioning rules for the assessment.
the default questioning rule is 'half_split'.}

\item{nrep}{Number of times in which each state is simulated. The default value is one.}
}
\value{
Efficiency and Accuracy curves plots.
}
\description{
Simulation producing efficiency and accuracy performance curves and indexes based on simulated assessment of all the states in structure
}
\examples{
# Consider the knowledge space and the parameters used in Brancaccio,
# de Chiusole, Stefanutti (2023) in Example 1

states<-matrix(c( 0,0,0,0,0,
                   0,0,0,0,1,
                   0,0,1,0,1,
                   0,0,0,1,1,
                   0,0,1,1,1,
                   1,0,1,0,1,
                   0,1,0,1,1,
                   1,0,1,1,1,
                   0,1,1,1,1,
                   1,1,0,1,1,
                   1,1,1,1,1), byrow=TRUE, ncol=5)
beta  <-c(.004,.03,.02,.01,.007)
eta   <-c(5e-06, 5e-05, 4e-05,.007,.08)
performance_simulation(states,beta,eta)
}
