% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_na.R, R/any_na.R, R/is_na.R, R/which_na.R
\name{all_na}
\alias{all_na}
\alias{all_na.default}
\alias{any_na}
\alias{is_na}
\alias{which_na}
\title{Tests for missing values}
\usage{
all_na(x)

\method{all_na}{default}(x)

any_na(x)

is_na()

which_na(x)
}
\arguments{
\item{x}{object to test.}
}
\value{
logical scalar indicating if values are missing.

logical scalar; either TRUE or FALSE.

\code{integer} of indexes of \code{x} that corerspond to elements
of x that are missing (\code{NA}).  Names of the result
are set to the names of \code{x}.
}
\description{
Test if all values are missing
}
\details{
These are S3 Generics that provide default methods.

\code{all_na} reports if \strong{all} values are missing.

\code{any_na} reports if \strong{any} values are missing. If always returns a logical
scalar.

\code{is_na} is a wrapper around \code{\link[base:is.na]{base::is.na()}} created to keep stylistic
consistenct with the other functions.

\code{which_na} is implemented as \code{which( is.na(x) )}.
It is a S3 generic function.
}
\examples{

  all_na( c( NA, NA, 1 ) )    # FALSE
  all_na( c( NA, NA, NA ) )   # TRUE
  
  df <- data.frame( char = rep(NA_character_, 3), nums=1:3)
  all_na(df)  # FALSE
  
  df <- data.frame( char = rep(NA_character_, 3), nums=rep(NA_real_,3))
  all_na(df)  # TRUE
  
  any_na( 1:10 )           # FALSE
  any_na( c( 1, NA, 3 ) )  # TRUE


  x <- c( 1, NA, NA, 4:6 )
  which_na(x)
  
  names(x) <- letters[1:6]
  which_na(x)
 
}
\seealso{
\itemize{
\item \code{\link[base:anyNA]{base::anyNA()}}
}

\itemize{
\item \code{\link[base:is.na]{base::is.na()}} - for the variant returning logical
}
}
