% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-factor.R
\name{impute_factor}
\alias{impute_factor}
\alias{impute_factor.default}
\alias{impute_factor.factor}
\alias{impute_factor.character}
\alias{impute_factor.shade}
\title{Impute a factor value into a vector with missing values}
\usage{
impute_factor(x, value)

\method{impute_factor}{default}(x, value)

\method{impute_factor}{factor}(x, value)

\method{impute_factor}{character}(x, value)

\method{impute_factor}{shade}(x, value)
}
\arguments{
\item{x}{vector}

\item{value}{factor to impute}
}
\value{
vector with a factor values replaced
}
\description{
For imputing fixed factor levels. It adds the new imputed value to the end
of the levels of the vector. We generally recommend to impute using other
model based approaches. See the \code{simputation} package, for example
\code{\link[simputation:impute_lm]{simputation::impute_lm()}}.
}
\examples{

vec <- factor(LETTERS[1:10])

vec[sample(1:10, 3)] <- NA

vec

impute_factor(vec, "wat")

library(dplyr)

dat <- tibble(
  num = rnorm(10),
  int = rpois(10, 5),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat

dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_fixed(num, -9999),
    int = impute_zero(int),
    fct = impute_factor(fct, "out")
  )

}
