% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-fixed.R
\name{impute_fixed}
\alias{impute_fixed}
\alias{impute_fixed.default}
\title{Impute a fixed value into a vector with missing values}
\usage{
impute_fixed(x, value)

\method{impute_fixed}{default}(x, value)
}
\arguments{
\item{x}{vector}

\item{value}{value to impute}
}
\value{
vector with a fixed values replaced
}
\description{
This can be useful if you are imputing specific values, however we would
generally recommend to impute using other model based approaches. See
the \code{simputation} package, for example \code{\link[simputation:impute_lm]{simputation::impute_lm()}}.
}
\examples{

vec <- rnorm(10)

vec[sample(1:10, 3)] <- NA

vec

impute_fixed(vec, -999)

library(dplyr)

dat <- tibble(
  num = rnorm(10),
  int = rpois(10, 5),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat

dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_fixed(num, -9999),
    int = impute_zero(int),
    fct = impute_factor(fct, "out")
  )

}
