% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-x-summary.R
\name{miss_var_summary}
\alias{miss_var_summary}
\title{Summarise the missingness in each variable}
\usage{
miss_var_summary(data, order = FALSE, add_cumsum = FALSE, digits, ...)
}
\arguments{
\item{data}{a data.frame}

\item{order}{a logical indicating whether to order the result by \code{n_miss}.
Defaults to TRUE. If FALSE, order of variables is the order input.}

\item{add_cumsum}{logical indicating whether or not to add the cumulative
sum of missings to the data. This can be useful when exploring patterns
of nonresponse. These are calculated as the cumulative sum of the missings
in the variables as they are first presented to the function.}

\item{digits}{how many digits to display in \code{pct_miss} column. Useful when
you are working with small amounts of missing data.}

\item{...}{extra arguments}
}
\value{
a tibble of the percent of missing data in each variable
}
\description{
Provide a summary for each variable of the number, percent missings, and
cumulative sum of missings of the order of the variables. By default,
it orders by the most missings in each variable.
}
\note{
\code{n_miss_cumsum} is calculated as the cumulative sum of missings in the
variables in the order that they are given in the data when entering
the function
}
\examples{

miss_var_summary(airquality)
miss_var_summary(oceanbuoys, order = TRUE)

\dontrun{
# works with group_by from dplyr
library(dplyr)
airquality \%>\%
  group_by(Month) \%>\%
  miss_var_summary()
}
}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \code{\link[=miss_case_summary]{miss_case_summary()}} \code{\link[=miss_case_table]{miss_case_table()}} \code{\link[=miss_summary]{miss_summary()}} \code{\link[=miss_var_prop]{miss_var_prop()}} \code{\link[=miss_var_run]{miss_var_run()}} \code{\link[=miss_var_span]{miss_var_span()}} \code{\link[=miss_var_summary]{miss_var_summary()}} \code{\link[=miss_var_table]{miss_var_table()}} \code{\link[=n_complete]{n_complete()}} \code{\link[=n_complete_row]{n_complete_row()}} \code{\link[=n_miss]{n_miss()}} \code{\link[=n_miss_row]{n_miss_row()}} \code{\link[=pct_complete]{pct_complete()}} \code{\link[=pct_miss]{pct_miss()}} \code{\link[=prop_complete]{prop_complete()}} \code{\link[=prop_complete_row]{prop_complete_row()}} \code{\link[=prop_miss]{prop_miss()}}
}
