% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_epic_earth_images.R
\name{get_epic_earth_images}
\alias{get_epic_earth_images}
\title{Retrieve and Save EPIC Natural Color Earth Images}
\usage{
get_epic_earth_images(date = NULL, api_key = "DEMO_KEY", folder_name = NULL)
}
\arguments{
\item{date}{Character or NULL. The Earth date in "YYYY-MM-DD" format to retrieve images from.
If NULL, today's date is used. Note that today's images may not yet be available.}

\item{api_key}{Character. NASA API key. Defaults to \code{"DEMO_KEY"}, but a personal API key is recommended.}

\item{folder_name}{Character or NULL. If provided, images will be saved in a folder with this name on the user's Desktop.
If NULL, images are only displayed and not saved.}
}
\value{
A data frame containing metadata for the retrieved EPIC images, including image names, dates, and captions.
}
\description{
Queries NASA's EPIC (Earth Polychromatic Imaging Camera) API to retrieve metadata
and images of Earth taken on a specified date. Images can optionally be saved to a folder on the user's Desktop.
}
\details{
The function builds the download URLs based on NASA's EPIC archive structure, which organizes images into
year/month/day subfolders. Only natural color images are retrieved.
Images are displayed using the \code{magick} package and can be optionally saved as PNG files.
}
\examples{
\dontrun{
# Retrieve and view EPIC images from April 1, 2024
epic_data <- get_epic_earth_images(date = "2024-04-01", api_key = "your_actual_api_key")

# Retrieve and save EPIC images to Desktop/EPIC_Images
epic_data_saved <- get_epic_earth_images(
  date = "2024-04-01",
  api_key = "DEMO_KEY",
  folder_name = "EPIC_Images"
)
}

}
