% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X_ned2ellips.R
\name{X_ned2ellips}
\alias{X_ned2ellips}
\title{Transform position from NED to ellipsoidal coordinates}
\usage{
X_ned2ellips(x, x_o = NULL)
}
\arguments{
\item{x}{An object of class \code{trajectory} in "NED" system or a matrix of position data with x_N, x_E, and x_D}

\item{x_o}{Origin of the fixed Cartesian NED frame expressed in ellipsoidal coordinates}
}
\value{
An object of class \code{trajectory} in "ellipsoidal" system or a matrix of position data with latitude, longitude, and altitude, according to the type of input \code{x}
}
\description{
Transform position from a fixed Cartesian NED frame to ellipsoidal coordinates
}
\examples{

data("example_1_traj_ned")
traj_ned <- make_trajectory(example_1_traj_ned, system = "ned")
plot(traj_ned)
traj_ellips <- X_ned2ellips(traj_ned, x_o = example_1_traj_ellipsoidal[1, -1])
plot(traj_ellips, threeD = FALSE)
plot(traj_ellips, threeD = TRUE)

}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
