% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nawt.R
\name{plot.nawt}
\alias{plot.nawt}
\title{Plot a scattered plot comparing the navigated weighting and naive estimation}
\usage{
\method{plot}{nawt}(x, ...)
}
\arguments{
\item{x}{an object of class “nawt”, usually, a result of a call to \code{\link{nawt}}.}

\item{...}{additional arguments to be passed to plot.}
}
\value{
No retrun value, called for side effects.
}
\description{
Plots a scattered plot comparing the resulting inverse probability weights 
estimated by the navigated weighting and the standard logistic regression.
}
\details{
The x-axis shows the inverse probability weights estimated by estimating 
propensity scores with the standard logistic regression whereas the y-axis
shows those with the navigated weighting. Excessively heavy weights on only a
few observations in the navigated weighting may indicate the failure of 
the estimation.

Position of the legend is determined internally.
}
\examples{
# Simulation from Kang and Shafer (2007) and Imai and Ratkovic (2014)
tau <- 10
set.seed(12345)
n <- 1000
X <- matrix(rnorm(n * 4, mean = 0, sd = 1), nrow = n, ncol = 4)
prop <- 1 / (1 + exp(X[, 1] - 0.5 * X[, 2] + 0.25 * X[, 3] + 0.1 * X[, 4]))
treat <- rbinom(n, 1, prop)
y <- 210 + 27.4 * X[, 1] + 13.7 * X[, 2] + 13.7 * X[, 3] + 13.7 * X[, 4] + 
     tau * treat + rnorm(n)

# Data frame and formulas for propensity score estimation
df <- data.frame(X, treat, y)
colnames(df) <- c("x1", "x2", "x3", "x4", "treat", "y")
formula_c <- as.formula(treat ~ x1 + x2 + x3 + x4)

# Power weighting function with alpha = 2
# ATT estimation
fitatt <- nawt(formula = formula_c, outcome = "y", estimand = "ATT", 
               method = "score", data = df, alpha = 2)
plot(fitatt)

# ATE estimation
fitate <- nawt(formula = formula_c, outcome = "y", estimand = "ATE", 
               method = "score", data = df, alpha = 2)
plot(fitate)
}
\seealso{
\code{\link{nawt}}, \code{\link[graphics]{plot}}
}
\author{
Hiroto Katsumata
}
