% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_extra.R
\name{ova2nbc}
\alias{ova2nbc}
\title{Translate open verbal autopsy arguments to train a NBC model}
\usage{
ova2nbc(symps.train, symps.test, causes.train, causes.table = NULL, ...)
}
\arguments{
\item{symps.train}{Dataframe of verbal autopsy train data.
\itemize{
  \item Columns (in order): ID, Cause, Symptom-1 to Symptom-n..
  \item ID (vectorof char): case identifiers
  \item Cause (vectorof char): observed causes for each case
  \item Symptom-n.. (vectorsof char): "Y" for presence, "" for absence, "." for missing
}
Example:
\tabular{ccccc}{
  ID \tab Cause \tab S1 \tab S2 \tab S3 \cr
  "a1" \tab "HIV" \tab "Y" \tab "" \tab "."\cr
  "b2" \tab "Stroke" \tab "." \tab "" \tab "Y"\cr
  "c3" \tab "HIV" \tab "Y" \tab "Y" \tab "."
}}

\item{symps.test}{Dataframe of verbal autopsy test data in the same format as \emph{symps.train}.
\itemize{
  \item If (\emph{causes.train} is (vectorof char)): \emph{symps.test} is assumed to not have a cause column
}}

\item{causes.train}{The train vector or column for the causes of death to use.
\itemize{
  \item If (vectorof char): cause of death values with number of values equal to nrow(\emph{symps.train});
        it is assumed that \emph{symps.test} has no causes of death column
  \item If (char): name of cause of death column from \emph{symps.train}
}}

\item{causes.table}{Character list of unique causes to learn.
\itemize{
  \item If (NULL): set to unique causes of death in \emph{symps.train}
}}

\item{...}{Additional arguments to be passed to avoid errors if necessary.}
}
\value{
nbc An \code{\link{nbc}} object with the following modifications:
\itemize{
  \item $id (vectorof char): set to test data ids
  \item $prob (matrixof numeric): set to a matrix of likelihood for each cause of death for the test cases
  \item $CSMF (vectorof char): set to the predicted CSMFs with names for the corresponding causes
}
}
\description{
A wrapper function for creating an nbc object with the parameters specified by
the \href{https://cran.r-project.org/package=openVA}{\pkg{openVA}} package.
}
\examples{
\dontrun{
library(openVA)  # install.packages("openVA")
library(nbc4va)

# Obtain some openVA formatted data
data(RandomVA3) # cols: deathId, cause, symptoms..
train <- RandomVA3[1:100, ]
test <- RandomVA3[101:200, ]

# Run naive bayes classifier on openVA data
results <- ova2nbc(train, test, "cause")

# Obtain the probabilities and predictions
prob <- results$prob.causes
pred <- results$pred.causes
}

}
\references{
\itemize{
  \item Li Z, McCormick T, Clark S. openVA: Automated Method for Verbal Autopsy [Internet]. 2016. [cited 2016 Apr 29]. Available from: \url{https://cran.r-project.org/package=openVA}
}
}
\concept{extra functions}
